//
//	$Date: 2001/03/23 17:51:35 $
//	$Revision: 1.10 $
//
//	PalmWiki Version = 0.1.6
//

#pragma pack(2)

#include <Pilot.h>
#include "palmwiki.h"
#include "id.h"

#define IsUpper(c) ((c) >= 'A' && (c) <= 'Z')
#define IsLower(c) ((c) >= 'a' && (c) <= 'z')
#define IsAlpha(c) (IsLower(c) || IsUpper(c))
#define IsDigit(c) ((c) >= '0' && (c) <= '9')
#define IsDelim(c) ((c) == '/' || (c) == '.')

#define FEATURE_CURSORPOS 10

typedef Err FldHandleEventTrapFunc(FieldPtr,EventPtr);

typedef enum {
	KEYWORD,
	WIKINAME,
	DATE,
	FAIL
} WikiType;

WikiType FindKeyword(char *s,int pos,int length,int *start,int *end,WikiPref *prefp);
void LaunchMemo(char *str,char *app);
void LaunchSchedule(int year,int month,int day,char *app);

static unsigned long StringToLong(char *s)
{
	unsigned long val = 0;
	int i;
	for(i=0;i<4;i++){
		val = ((val << 8) + s[i]);
	}
	return val;
}

//
//	Replace sysTrapFldHandleEvent() with this hack function
//
Err Wiki(FieldPtr fld, EventPtr e)
{
	DWord ftrvalue;
	FldHandleEventTrapFunc *trapfunc;
	Err ret;
	char *fieldtext;
	UShort selstart,selend;
	int start,end,fieldlength;
	char buf[100];
	WikiType type;
	char *d;
	int i;
	WikiPref pref;
	int prefsize;
	UShort lastpos, newpos;

	//
	// Get the original trap address of FldHandleEvent and
	// invoke it.
	//
	FtrGet(CREATOR,1000,&ftrvalue);
	trapfunc = (FldHandleEventTrapFunc*)ftrvalue;
	ret = (*trapfunc)(fld,e);

	fieldtext = FldGetTextPtr(fld);
	if(fieldtext == NULL) return ret;

	fieldlength = FldGetTextLength(fld);

//	FldGetSelection(fld,&newpos,&selend);

	switch(e->eType){
	case penDownEvent:
		//
		// Get preferences
		//
		prefsize = sizeof(WikiPref);
		PrefGetAppPreferences(CREATOR,0,&pref,&prefsize,true);

		// remember current cursor position
		newpos = FldGetInsPtPosition(fld);
		ftrvalue = newpos;
		FtrSet(CREATOR,FEATURE_CURSORPOS,ftrvalue); 

		return ret;

		break;
	case fldEnterEvent:
		//dragging, etc.

		//
		// Get preferences
		//
		prefsize = sizeof(WikiPref);
		PrefGetAppPreferences(CREATOR,0,&pref,&prefsize,true);

		FldGetSelection(fld,&selstart,&selend);

		if(pref.singletap){
			if(selstart != selend) return ret;
		}
		else {
			// get last cursor position
			FtrGet(CREATOR,FEATURE_CURSORPOS,&ftrvalue);
			lastpos = ftrvalue;
			if(lastpos < selstart || lastpos > selend) return ret;
		}
		break;
	default:
		return ret;
	}

	//
	// Get preferences
	//
	prefsize = sizeof(WikiPref);
	if(PrefGetAppPreferences(CREATOR,0,&pref,&prefsize,true) == noPreferenceFound){
		// ErrFatalDisplayIf(true,"Can't open Pref DB");
		StrCopy(pref.lpar,DEFAULT_LEFT_TAG);
		StrCopy(pref.rpar,DEFAULT_RIGHT_TAG);
		StrCopy(pref.memo,DEFAULT_MEMO_APP);
		StrCopy(pref.date,DEFAULT_DATE_APP);
		pref.singletap = true;
		PrefSetAppPreferences(CREATOR,0,1,&pref,sizeof(WikiPref),true);
	}

	//
	// Get the WikiName around cursor
	//
	type = FindKeyword(fieldtext,selstart,fieldlength,&start,&end,&pref);
	if(type==FAIL) return ret;

	if(end-start > 90) return ret;

	if(type==KEYWORD){
		StrNCopy(buf,fieldtext+start,end-start);
		StrCopy(buf+end-start,"\n");
	}
	if(type==WIKINAME){
		d = buf;
		for(i=start;i<end;i++){
#ifdef ADDSPACEFORWIKINAME
			if(i>start && IsUpper(fieldtext[i])){
				*d++ = ' ';
			}
#endif		
			*d++ = fieldtext[i];
		}
		StrCopy(d,"\n");
	}
	LaunchMemo(buf,pref.memo);

	return ret;
}

//
//	Look for an Wiki Keyword
//
WikiType FindKeyword(char *s,int pos,int length,int *sp,int *ep,WikiPref *prefp)
{
	Boolean beginfound,endfound;
	int linestart,lineend;
	int start,end;
	int i;
	int state;
	char c;
	int lparlen,rparlen;
	int year,month,day;

	// Check a string surrounded by lpar and rpar
	lparlen = StrLen(prefp->lpar);
	rparlen = StrLen(prefp->rpar);

	beginfound = endfound = false;
	for(linestart=pos;linestart>0;linestart--){
		if(s[linestart-1]=='\n') break;
	}
	for(lineend=pos;lineend<length;lineend++){
		if(s[lineend]=='\0'||s[lineend]=='\n') break;
	}

	for(start=pos;start>=linestart+lparlen;start--){
		if(StrNCompare(s+start-lparlen,prefp->lpar,lparlen)==0){
			int sjis = false;
			for(i=linestart;i<start-lparlen;){
				sjis = ((*(s+i) & 0x80) ? true : false);
				i += (sjis ? 2 : 1);
			}
			if(i == start-lparlen){
				beginfound = true;
				break;
			}
		}
	}
	if(beginfound){
		for(end=pos;end<=lineend-rparlen;){
			if(StrNCompare(s+end,prefp->rpar,rparlen)==0){
				endfound = true;
				break;
			}
			end += ((*(s+end) & 0x80) ? 2 : 1);
		}
		if(endfound){
			if(start == end) return FAIL;
			*sp = start;
			*ep = end;
			return KEYWORD;
		}
	}

	//
	// Check WikiNames
	//
	start = i = linestart;
	while(i<pos){
		if(s[i] & 0x80){
			i += 2;
			start = i;
			continue;
		}
		if(!IsAlpha(s[i])){
			i++;
			start = i;
			continue;
		}
		i++;
	}
	for(end=pos;end<lineend;end++){
		if(!IsAlpha(s[end])) break;
	}

	// check if s[start..end] is an WikiName
	state = 0;
	for(i=start;i<end;i++){
		c = s[i];
		switch(state){
		case 0:	if(IsUpper(c)) state = 1;
			else state = -1;
			break;
		case 1:	if(IsLower(c)) state = 2;
			else state = -1;
			break;
		case 2:	if(IsUpper(c)) state = 3;
			else if(IsLower(c)) state = 2;
			else state = -1;
			break;
		case 3:	if(IsLower(c)) state = 4;
			else state = -1;
			break;
		case 4:	if(IsUpper(c)) state = 3;
			else if(IsLower(c)) state = 4;
			else state = -1;
			break;
		default:
			break;
		}
	}
	if(state == 4){
		*sp = start;
		*ep = end;
		return WIKINAME;
	}

	//
	// Check year/month/day
	//
	for(start=pos;start>=linestart;start--){
		if(!IsDigit(s[start]) && !IsDelim(s[start])) break;
	}
	start++;
	for(end=pos;end<lineend;end++){
		if(!IsDigit(s[end]) && !IsDelim(s[end])) break;
	}
	year = month = day = 0;
	for(i=start;i<end && !IsDelim(s[i]);i++){
		year = year * 10 + s[i] - '0';
	}
	i++;
	for(;i<end && !IsDelim(s[i]);i++){
		month = month * 10 + s[i] - '0';
	}
	i++;
	for(;i<end;i++){
		day = day * 10 + s[i] - '0';
	}
	if(month >= 1 && month <= 12 && day >= 1 && day <= 31){
		if(year < 70){ year += 2000; }
		else if(year < 100){ year += 1900; }
		LaunchSchedule(year,month,day,prefp->date);
	}
	
	return FAIL;
}

void LaunchMemo(char *str, char *app)
{
	int i;
	int nrecords;
	DmOpenRef db,memo;
	VoidHand h;
	char *s0;
	int size;
	UInt recordno;
	Err err;
	Boolean found;

	GoToParamsType *cmdPBP;
	LocalID memoappid;
	unsigned short memoappcardno;
	LocalID memodbid;
	unsigned short memodbcardno;
	DmSearchStateType state;

	LocalID id;
	UInt cardno;
	ULong type,creator;
	Boolean memoisopen;

	// check all the open database and see if memo is currently open
	memoisopen = false;
	db = DmNextOpenDatabase(NULL);
	while(db){
		DmOpenDatabaseInfo(db,&id,
			NULL,NULL,&cardno,NULL);
		DmDatabaseInfo(cardno,id,
			NULL,NULL,NULL,
			NULL,NULL,NULL,
			NULL,NULL,NULL,
			&type,&creator);
		if(type == 'DATA' && creator == 'memo'){
			memoisopen = true;
			break;
		}
		db = DmNextOpenDatabase(db);
	}
	if(memoisopen){
		memo = db;
	}
	else {
		memo = DmOpenDatabaseByTypeCreator('DATA','memo',dmModeReadWrite);
	}
	if(memo == NULL) return;

	nrecords = DmNumRecords(memo);
	recordno = nrecords;
	found = false;
	for(i=nrecords-1;i>=0 && !found;i--){
		h = DmQueryRecord(memo,i);
		if(h && (s0 = MemHandleLock(h))){
			size = MemPtrSize(s0);
			if(size >= StrLen(str) && StrNCompare(s0,str,StrLen(str))==0){
				recordno = i;
				found = true;
			}
			MemHandleUnlock(h);
		}
	}
	if(!found){
		h = DmNewRecord(memo,&recordno,StrLen(str)+1);
		if(h && (s0 = MemHandleLock(h))){
			err = DmWrite(s0,0,str,StrLen(str)+1);
			ErrFatalDisplayIf(err,"DmWrite");
			DmReleaseRecord(memo,recordno,true);
			MemHandleUnlock(h);
		}
	}
	DmOpenDatabaseInfo(memo,&memodbid,NULL,NULL,&memodbcardno,NULL);
	if(!memoisopen){
		DmCloseDatabase(memo);
	}

	//
	// Launch the 'memo' application. This seems to work even where
	// memo is already running.
	//
	cmdPBP = (GoToParamsType*)MemPtrNew(sizeof(GoToParamsType));
	DmGetNextDatabaseByTypeCreator(true,&state,'appl',
		StringToLong(app), // 'memo', etc.
		false,&memoappcardno,&memoappid);
	cmdPBP->searchStrLen = 0;
	cmdPBP->dbCardNo = memodbcardno;
	cmdPBP->dbID = memodbid;
	cmdPBP->recordNum = recordno;
	cmdPBP->matchPos = 0;
	cmdPBP->matchFieldNum = 0; 
	cmdPBP->matchCustom = 0;
	MemPtrSetOwner((VoidPtr)cmdPBP,0);
	SysUIAppSwitch(memoappcardno,memoappid,sysAppLaunchCmdGoTo,(Ptr)cmdPBP);
}

void LaunchSchedule(int year,int month,int day,char *app)
{
	unsigned char newdata[20];

	int nrecords;
	DmOpenRef db,schedule;
	VoidHand h;
	unsigned char *s0;
	UInt recordno, lastrecordno;
	Err err;

	GoToParamsType *cmdPBP;
	LocalID scheduleappid;
	unsigned short scheduleappcardno;
	LocalID scheduledbid;
	unsigned short scheduledbcardno;
	DmSearchStateType state;

	LocalID id;
	UInt cardno;
	ULong type,creator;
	Boolean scheduleisopen;

	unsigned short packed;
	unsigned int byear,bmonth,bday;
	long diff,newdiff;
	unsigned short d;

	Boolean found;
	Boolean nodata;

	DateType date, jumpdate;
	unsigned long days, jumpdays;

	// check all the open database and see if schedule is currently open
	scheduleisopen = false;
	db = DmNextOpenDatabase(NULL);
	while(db){
		DmOpenDatabaseInfo(db,&id,
			NULL,NULL,&cardno,NULL);
		DmDatabaseInfo(cardno,id,
			NULL,NULL,NULL,
			NULL,NULL,NULL,
			NULL,NULL,NULL,
			&type,&creator);
		if(type == 'DATA' && creator == 'date'){
			scheduleisopen = true;
			break;
		}
		db = DmNextOpenDatabase(db);
	}
	if(scheduleisopen){
		schedule = db;
	}
	else {
#ifdef CREATERECORD
		schedule = DmOpenDatabaseByTypeCreator('DATA','date',dmModeReadWrite);
#else
		schedule = DmOpenDatabaseByTypeCreator('DATA','date',dmModeReadOnly);
#endif
	}
	if(schedule == NULL) return;

	found = false;
	nodata = true; // even when nrecords > 0, all the data might have been deleted.
	nrecords = DmNumRecords(schedule);
	if(nrecords <= 0) return; // no schedule data

	lastrecordno = 0;
	diff = 1000000;
	jumpdate.year = year-1904;
	jumpdate.month = month;
	jumpdate.day = day;
	jumpdays = DateToDays(jumpdate);

	for(recordno=0;recordno<nrecords;recordno++){
		h = DmQueryRecord(schedule,recordno);
		if(h) nodata = false;
		if(h && (s0 = MemHandleLock(h))){
			date = *((DateType*)(s0+4));
			MemHandleUnlock(h);

			days = DateToDays(date);

			newdiff = (long)days - (long)jumpdays;
			if(newdiff < 0) newdiff = -newdiff;
			if(newdiff < diff){
				lastrecordno = recordno;
				diff = newdiff;
			}
		}
	}

	if(1){ // if(! found){
#ifdef CREATERECORD
		//
		// create a new record with no time specification
		//
		MemMove(newdata,"\377\377\377\377xx\004\262(new data)\000",19);
		packed = ((year-1900-4)<<9)+(month<<5)+day;
		newdata[4] = (packed>>8);
		newdata[5] = (packed&0xff);

		h = DmNewRecord(schedule,&recordno,19);
		if(h && (s0 = MemHandleLock(h))){
			err = DmWrite(s0,0,newdata,19);
			ErrFatalDisplayIf(err,"DmWrite");
			DmReleaseRecord(schedule,recordno,true);
			MemHandleUnlock(h);
		}
#else
		recordno = lastrecordno;
#endif
	}
	DmOpenDatabaseInfo(schedule,&scheduledbid,NULL,NULL,&scheduledbcardno,NULL);
	if(!scheduleisopen){
		DmCloseDatabase(schedule);
	}

	if(nodata) return;

	//
	// Launch the 'schedule' application. This seems to work even where
	// schedule is already running.
	//
	cmdPBP = (GoToParamsType*)MemPtrNew(sizeof(GoToParamsType));
	DmGetNextDatabaseByTypeCreator(true,&state,'appl',
		StringToLong(app), // 'date', etc.
		false,&scheduleappcardno,&scheduleappid);
	cmdPBP->searchStrLen = 0;
	cmdPBP->dbCardNo = scheduledbcardno;
	cmdPBP->dbID = scheduledbid;
	cmdPBP->recordNum = recordno;
	cmdPBP->matchPos = 0;
	cmdPBP->matchFieldNum = 0; 
	cmdPBP->matchCustom = 0;
	MemPtrSetOwner((VoidPtr)cmdPBP,0);
	SysUIAppSwitch(scheduleappcardno,scheduleappid,sysAppLaunchCmdGoTo,(Ptr)cmdPBP);
}

