#!/usr/local/bin/perl
#  $Revision: 1.1 $
#  Tatsuya Aoyagi (aoyagi@cs.uec.ac.jp)
#  $Id: build-prc.perl,v 1.1 1997/12/13 16:48:58 masui Exp masui $
#
# usage: build-prc.perl prcfile name type creatorID resource ...


if (@ARGV < 4) {
    print STDERR "usage: build-prc.perl prcfile name type creatorID resource ...\n";
    exit(1);
}
$PrcFileName = shift(@ARGV);
$Name = shift(@ARGV);
$Type = shift(@ARGV);
$CreatorID = shift(@ARGV);

$NumOfResource = @ARGV;

$PrcHeaderSize = 78;
$PaddingSize = 2;
$RscHeaderSize = 10;

@RscType = ();
@RscID = ();
@RscOffset = ();

if (&setOffset != 0) {
    exit(1);
}
if (&setTypeAndID != 0) {
    exit(1);
}
unless (open(PRC,">$PrcFileName")) {
    print STDERR "can't open prcfile $PrcFileName\n";
    exit(1);
}
binmode(PRC);
&writePrcHeader;
&writeRscHeader;
if (&writeResouce != 0) {
    exit(1);
}
close(PRC);

sub setOffset {
    local($offset,$rscfile,$rsclen);

    $offset = $PrcHeaderSize + $RscHeaderSize * $NumOfResource + $PaddingSize;
    foreach $rscfile (@ARGV) {
	push(@RscOffset,$offset);
	unless (-r $rscfile) {
	    print STDERR "can't read resource file $rscfile\n";
	    return -1;
	}
	$rsclen = -s $rscfile;
	$offset += $rsclen;
    }
    return 0;
}

sub setTypeAndID {
    local($type,$id,$rscfile,@path,$file);
    foreach $rscfile (@ARGV) {
	@path = split(/\//,$rscfile);
	$file = $path[$#path];
	if ($file =~ /(.{4})([0-9a-f]{4})/i) {
	    $type = $1;
	    $id = hex($2);
	} else {
	    print STDERR "invalid resource file name $rscfile\n";
	    return -1;
	}
	push(@RscType,$type);
	push(@RscID,$id);
    }
    return 0;
}

sub writePrcHeader {
    local($flag,$version,$createTime,$modTime,$backUpTime,$modTime);
    local($appInfo,$sortInfo,$uniqueIdSeed,$nextRecordList);
    $flag = 0x01;
    $version = 0x01;
    $createTime = 0xadc0bea0;
    $modTime = 0xadc0bea0;
    $backUpTime = 0x00000000;
    $modNum = 0;
    $appInfo = 0;
    $sortInfo = 0;
    $uniqueIdSeed = 0x28000000; # ??
    $nextRecordList = 0;

    print PRC pack("a32",$Name);
    print PRC pack("nn",$flag,$version);
    print PRC pack("NNN",$createTime,$modTime,$backUpTime);
    print PRC pack("NNN",$modNum,$appInfo,$sortInfo);
    print PRC pack("a4",$Type);
    print PRC pack("a4",$CreatorID);
    print PRC pack("NN",$uniqueIdSeed,$nextRecordList);
    print PRC pack("n",$NumOfResource);
}

sub writeRscHeader {
    local($i);
    for ($i = 0; $i < $NumOfResource; $i++) {
	print PRC pack("a4",$RscType[$i]);
	print PRC pack("n",$RscID[$i]);
	print PRC pack("N",$RscOffset[$i]);
    }
    print PRC pack("n",0); # padding
}

sub writeResouce {
    local($rscfile);
    foreach $rscfile (@ARGV) {
	unless (open(RSC,$rscfile)) {
	    print STDERR "can't open resource file $rscfile\n";
	    return -1;
	}
	binmode(RSC);
	undef $/;
	print PRC <RSC>;
	close(RSC);
    }
    return 0;
}
