//
//	$Date: 2001/03/27 08:27:40 $
//	$Revision: 1.15 $
//
//	PalmWiki Version = 0.2.2
//

#pragma pack(2)

#include <Pilot.h>
#include "DropModule.h" // Drag&DropW[pwb_
#include "palmwiki.h"
#include "id.h"

#define IsUpper(c) ((c) >= 'A' && (c) <= 'Z')
#define IsLower(c) ((c) >= 'a' && (c) <= 'z')
#define IsAlpha(c) (IsLower(c) || IsUpper(c))
#define IsDigit(c) ((c) >= '0' && (c) <= '9')
#define IsDelim(c) ((c) == '/' || (c) == '.')
#define IsSJIS(c) (((c) >= 0x80 && (c) <= 0x9f) || ((c) >= 0xe0 && (c) <= 0xfe))

#define FEATURE_CURSORPOS 10

typedef Err FldHandleEventTrapFunc(FieldPtr,EventPtr);

typedef enum {
	KEYWORD,
	WIKINAME,
	DATE,
	FAIL
} WikiType;

//WikiType FindKeyword(char *s,int pos,int length,int *start,int *end,WikiPref *prefp);
void LaunchMemo(char *str,char *app);
void LaunchSchedule(int year,int month,int day,char *app);

Boolean ConvertPOBox(unsigned char *pat, unsigned char *dst);
Boolean DoDragAndDrop(unsigned char *src, unsigned char *dst);

static unsigned long StringToLong(char *s)
{
	unsigned long val = 0;
	int i;
	for(i=0;i<4;i++){
		val = ((val << 8) + s[i]);
	}
	return val;
}

void
ReplaceString(char *s1, int b1, int e1, char *s2, int b2, int e2)
{
	char buf1[100],buf2[100];

	if(StrLen(s1+e1) > 100-1) return;
	if(e2-b2 > 100) return;

	StrCopy(buf1,s1+e1);
	StrNCopy(buf2,s2+b2,e2-b2);
	StrNCopy(s1+b1,buf2,e2-b2);
	StrCopy(s1+b1+e2-b2,buf1);
}

int
CheckWikiName(unsigned char *buf, UShort *start, UShort *end)
{
	int wstart, wend;
	int state;
	int i;
	char c;
	int l;
	int buflen = StrLen(buf);
	//
	// Check WikiNames
	//
	wstart = l = 0;
	while(l<*start){
		if(IsSJIS(buf[l])){
			l += 2;
			wstart = l;
			continue;
		}
		if(!IsAlpha(buf[l])){
			l++;
			wstart = l;
			continue;
		}
		l++;
	}
	for(wend= *end;wend<buflen;wend++){
		if(!IsAlpha(buf[wend])) break;
	}

	// check if buf[wstart..wend] is an WikiName
	state = 0;
	for(i=wstart;i<wend;i++){
		c = buf[i];
		switch(state){
		case 0:	if(IsUpper(c)) state = 1;
			else state = -1;
			break;
		case 1:	if(IsLower(c)) state = 2;
			else state = -1;
			break;
		case 2:	if(IsUpper(c)) state = 3;
			else if(IsLower(c)) state = 2;
			else state = -1;
			break;
		case 3:	if(IsLower(c)) state = 4;
			else state = -1;
			break;
		case 4:	if(IsUpper(c)) state = 3;
			else if(IsLower(c)) state = 4;
			else state = -1;
			break;
		default:
			break;
		}
	}
	if(state == 4){
		*start = wstart;
		*end = wend;
		return 1;
	}
	return 0;
}

Boolean
FindTag(unsigned char *buf, int start, int end, int *lp, int *rp, char *ltag, char *rtag)
{
	int buflen = StrLen(buf);
	int lfound, rfound;
	int l,r,lastl;
	int ltaglen = StrLen(ltag);
	int rtaglen = StrLen(rtag);

	lfound = 0;
	for(l=ltaglen;l<=start;){
		if(StrNCompare(buf+l-ltaglen,ltag,ltaglen)==0){
			lfound = 1;
			lastl = l;
		}
		if(IsSJIS(buf[l-ltaglen])) l+=2;
		else l++;
	}
	rfound = 0;
	for(r=end;r+rtaglen<=buflen;r++){
		if(buf[r+rtaglen]=='\n') break;
		if(StrNCompare(buf+r,rtag,rtaglen)==0){
			rfound = 1;
			break;
		}
	}
	if(lfound && rfound){
		*lp = lastl;
		*rp = r;
		return true;
	}
	return false;
}

Boolean
Get3Val(char *s, int ss, int ee,
	int *val1, int *val2, int *val3, int delim)
{
	int i;
	int start,end;
	int v1,v2,v3;
	int delimcount;
/*
{
char buf[100];
StrPrintF(buf,"ss=%d, ee=%d",ss,ee);
WinDrawChars(buf,StrLen(buf),60,10);
StrPrintF(buf,"%s",s);
WinDrawChars(buf,StrLen(buf),60,20);
}
*/
	for(i=ss;i<ee;i++){
		if(!IsDigit(s[i]) && (s[i] != delim)) return false;
	}

	v1 = v2 = v3 = 0;
	for(start=ss;start>=0;start--){
		if(!IsDigit(s[start]) && s[start] != delim) break;
	}
	start++;
	for(end=ee;s[end];end++){
		if(!IsDigit(s[end]) && s[end] != delim) break;
	}

	// check if this really looks like a date string
	delimcount = 0;
	for(i=start;i<end;i++){
		if(IsDigit(s[i])) continue;
		if(s[i] == delim){
			delimcount++;
			continue;
		}
		return false;
	}
	if(delimcount != 2) return false;

	for(i=start;i<end && s[i] != delim;i++){
		v1 = v1 * 10 + s[i] - '0';
	}
	i++;
	for(;i<end && s[i] != delim;i++){
		v2 = v2 * 10 + s[i] - '0';
	}
	i++;
	for(;i<end;i++){
		v3 = v3 * 10 + s[i] - '0';
	}
	*val1 = v1;
	*val2 = v2;
	*val3 = v3;
	return true;
}

Boolean
CheckCalendar(char *s, int start, int end, char *app)
{
	unsigned long pref;
	int year,month,day;
	Boolean ok;

	pref = PrefGetPreference(prefDateFormat);

	switch(pref){
	case dfMDYWithSlashes:		// 12/31/95
		ok = Get3Val(s,start,end,&month,&day,&year,'/'); break;
	case dfDMYWithSlashes:		// 31/12/95
		ok = Get3Val(s,start,end,&day,&month,&year,'/'); break;
	case dfDMYWithDots:		// 31.12.95
		ok = Get3Val(s,start,end,&day,&month,&year,'.'); break;
	case dfDMYWithDashes:		// 31-12-95
		ok = Get3Val(s,start,end,&day,&month,&year,'-'); break;
	case dfYMDWithSlashes:		// 95/12/31
		ok = Get3Val(s,start,end,&year,&month,&day,'/'); break;
	case dfYMDWithDots:		// 95.12.31
		ok = Get3Val(s,start,end,&year,&month,&day,'.'); break;
	case dfYMDWithDashes:		// 95-12-31
		ok = Get3Val(s,start,end,&year,&month,&day,'-'); break;
	default:	
		ok = Get3Val(s,start,end,&year,&month,&day,'/'); break;
	}
	if(!ok) return false;
	if(month >= 1 && month <= 12 && day >= 1 && day <= 31){
		if(year < 70){ year += 2000; }
		else if(year < 100){ year += 1900; }
		LaunchSchedule(year,month,day,app);
		return true;
	}
	return false;
}

//
//	Replace sysTrapFldHandleEvent() with this hack function
//
Err Wiki(FieldPtr fld, EventPtr e)
{
	DWord ftrvalue;
	FldHandleEventTrapFunc *trapfunc;
	Err ret;
	char *fieldtext;
	int fieldsize;
	UShort selstart,selend;
	int start,end,fieldlength;
	char buf[100];
	char buf2[100];
	WikiPref pref;
	int prefsize;
	UShort lastpos, newpos;
	int ltaglen,rtaglen;
	int l,r;
	Boolean found;
//	Boolean launched = false;
	Boolean launchmemo = false;

	//
	// Get the original trap address of FldHandleEvent and
	// invoke it.
	//
	FtrGet(CREATOR,1000,&ftrvalue);
	trapfunc = (FldHandleEventTrapFunc*)ftrvalue;
	ret = (*trapfunc)(fld,e);

	fieldtext = FldGetTextPtr(fld);
	if(fieldtext == NULL) return ret;

	fieldlength = FldGetTextLength(fld);

//	FldGetSelection(fld,&newpos,&selend);

	selstart = selend = 0;
	switch(e->eType){
	case penDownEvent:
		//
		// Get preferences
		//
		prefsize = sizeof(WikiPref);
		PrefGetAppPreferences(CREATOR,0,&pref,&prefsize,true);

		// remember current cursor position
		newpos = FldGetInsPtPosition(fld);
		ftrvalue = newpos;
		FtrSet(CREATOR,FEATURE_CURSORPOS,ftrvalue); 

		return ret;

		break;
	case fldEnterEvent:
		//dragging, etc.

		//
		// Get preferences
		//
		prefsize = sizeof(WikiPref);
		PrefGetAppPreferences(CREATOR,0,&pref,&prefsize,true);

		FldGetSelection(fld,&selstart,&selend);

		if(pref.singletap){
			if(selstart != selend) return ret;
		}
		else {
			// get last cursor position
			FtrGet(CREATOR,FEATURE_CURSORPOS,&ftrvalue);
			lastpos = ftrvalue;
			if(lastpos < selstart || lastpos > selend) return ret;
		}
		break;
	default:
		return ret;
	}
	//
	// Get preferences
	//
	prefsize = sizeof(WikiPref);
	if(PrefGetAppPreferences(CREATOR,0,&pref,&prefsize,true) == noPreferenceFound){
		// ErrFatalDisplayIf(true,"Can't open Pref DB");
		StrCopy(pref.lpar,DEFAULT_LEFT_TAG);
		StrCopy(pref.rpar,DEFAULT_RIGHT_TAG);
		StrCopy(pref.memo,DEFAULT_MEMO_APP);
		StrCopy(pref.date,DEFAULT_DATE_APP);
		pref.singletap = true;
		PrefSetAppPreferences(CREATOR,0,1,&pref,sizeof(WikiPref),true);
	}
	for(start=selstart;start>0;start--){
		if(fieldtext[start-1]=='\n') break;
	}
	fieldsize = FldGetTextLength(fld);
	for(end=selend;end<fieldsize;end++){
		if(fieldtext[end]=='\0'||fieldtext[end]=='\n') break;
	}
	if(end-start >= 100-1) end = start+100-1;
	StrNCopy(buf,fieldtext+start,end-start);
	StrCopy(buf+end-start,"");
	selend = selstart = selstart-start;
	ltaglen = StrLen(pref.lpar);
	rtaglen = StrLen(pref.rpar);
	for(;;){
		if(selstart != selend){
			// look for POBox dictionary and convert it if applicable
			char pat[100];
			if(selend-selstart >= 100-1) return ret;
			StrNCopy(pat,buf+selstart,selend-selstart);
			StrCopy(pat+selend-selstart,"");
			if(ConvertPOBox((unsigned char*)pat,(unsigned char*)buf2)){
				Boolean usedata;
				usedata = DoDragAndDrop(pat,buf2);
				if(!usedata) return ret;
				ReplaceString(buf,selstart,selend,buf2,0,StrLen(buf2));
//WinDrawChars(buf,StrLen(buf),40,60);
				selend = selstart + StrLen(buf2);
//				selstart = 0;
//				selend = StrLen(buf);
//				selend = selstart;
			}
		}

		found = FindTag(buf,selstart,selend,&l,&r,pref.lpar,pref.rpar);
		if(found){
			ReplaceString(buf,l-ltaglen,r+rtaglen,buf,l,r);
			selstart = l-ltaglen;
			selend = r - ltaglen; 
		}
		else {
			CheckWikiName(buf,&selstart,&selend);

			if(selstart != selend){
				ReplaceString(buf,0,selend-selstart,buf,selstart,selend);
				StrCopy(buf+selend-selstart,"");
				selend = selend - selstart;
				selstart = 0;
				launchmemo = true;
//				LaunchMemo(buf,pref.memo);
			}
			break;
		}
	}
//	if(!launched){
//		launched = true;
//		CheckCalendar(buf,selstart,selend,pref.date);
//	}
	if(! CheckCalendar(buf,selstart,selend,pref.date) && launchmemo){
		LaunchMemo(buf,pref.memo);
	}
	return ret;
}

void LaunchMemo(char *str, char *app)
{
	int i;
	int nrecords;
	DmOpenRef db,memo;
	VoidHand h;
	char *s0;
	int size;
	UInt recordno;
	Err err;
	Boolean found;

	GoToParamsType *cmdPBP;
	LocalID memoappid;
	unsigned short memoappcardno;
	LocalID memodbid;
	unsigned short memodbcardno;
	DmSearchStateType state;

	LocalID id;
	UInt cardno;
	ULong type,creator;
	Boolean memoisopen;

	// check all the open database and see if memo is currently open
	memoisopen = false;
	db = DmNextOpenDatabase(NULL);
	while(db){
		DmOpenDatabaseInfo(db,&id,
			NULL,NULL,&cardno,NULL);
		DmDatabaseInfo(cardno,id,
			NULL,NULL,NULL,
			NULL,NULL,NULL,
			NULL,NULL,NULL,
			&type,&creator);
		if(type == 'DATA' && creator == 'memo'){
			memoisopen = true;
			break;
		}
		db = DmNextOpenDatabase(db);
	}
	if(memoisopen){
		memo = db;
	}
	else {
		memo = DmOpenDatabaseByTypeCreator('DATA','memo',dmModeReadWrite);
	}
	if(memo == NULL) return;

	nrecords = DmNumRecords(memo);
	recordno = nrecords;
	found = false;
	StrCat(str,"\n");
	for(i=nrecords-1;i>=0 && !found;i--){
		h = DmQueryRecord(memo,i);
		if(h && (s0 = MemHandleLock(h))){
			size = MemPtrSize(s0);
			if(size >= StrLen(str) && StrNCompare(s0,str,StrLen(str))==0){
				recordno = i;
				found = true;
			}
			MemHandleUnlock(h);
		}
	}
	if(!found){
		h = DmNewRecord(memo,&recordno,StrLen(str)+1);
		if(h && (s0 = MemHandleLock(h))){
			err = DmWrite(s0,0,str,StrLen(str)+1);
			ErrFatalDisplayIf(err,"DmWrite");
			DmReleaseRecord(memo,recordno,true);
			MemHandleUnlock(h);
		}
	}
	DmOpenDatabaseInfo(memo,&memodbid,NULL,NULL,&memodbcardno,NULL);
	if(!memoisopen){
		DmCloseDatabase(memo);
	}

	//
	// Launch the 'memo' application. This seems to work even where
	// memo is already running.
	//
	cmdPBP = (GoToParamsType*)MemPtrNew(sizeof(GoToParamsType));
	DmGetNextDatabaseByTypeCreator(true,&state,'appl',
		StringToLong(app), // 'memo', etc.
		false,&memoappcardno,&memoappid);
	cmdPBP->searchStrLen = 0;
	cmdPBP->dbCardNo = memodbcardno;
	cmdPBP->dbID = memodbid;
	cmdPBP->recordNum = recordno;
	cmdPBP->matchPos = 0;
	cmdPBP->matchFieldNum = 0; 
	cmdPBP->matchCustom = 0;
	MemPtrSetOwner((VoidPtr)cmdPBP,0);
	SysUIAppSwitch(memoappcardno,memoappid,sysAppLaunchCmdGoTo,(Ptr)cmdPBP);
}

void LaunchSchedule(int year,int month,int day,char *app)
{
//	unsigned char newdata[20];

	int nrecords;
	DmOpenRef db,schedule;
	VoidHand h;
	unsigned char *s0;
	UInt recordno, lastrecordno;
	Err err;

	GoToParamsType *cmdPBP;
	LocalID scheduleappid;
	unsigned short scheduleappcardno;
	LocalID scheduledbid;
	unsigned short scheduledbcardno;
	DmSearchStateType state;

	LocalID id;
	UInt cardno;
	ULong type,creator;
	Boolean scheduleisopen;

	long diff,newdiff;
	unsigned short d;

	Boolean found;
	Boolean nodata;

	DateType date, jumpdate;
	unsigned long days, jumpdays;

	// check all the open database and see if schedule is currently open
	scheduleisopen = false;
	db = DmNextOpenDatabase(NULL);
	while(db){
		DmOpenDatabaseInfo(db,&id,
			NULL,NULL,&cardno,NULL);
		DmDatabaseInfo(cardno,id,
			NULL,NULL,NULL,
			NULL,NULL,NULL,
			NULL,NULL,NULL,
			&type,&creator);
		if(type == 'DATA' && creator == 'date'){
			scheduleisopen = true;
			break;
		}
		db = DmNextOpenDatabase(db);
	}
	if(scheduleisopen){
		schedule = db;
	}
	else {
#ifdef CREATERECORD
		schedule = DmOpenDatabaseByTypeCreator('DATA','date',dmModeReadWrite);
#else
		schedule = DmOpenDatabaseByTypeCreator('DATA','date',dmModeReadOnly);
#endif
	}
	if(schedule == NULL) return;

	found = false;
	nodata = true; // even when nrecords > 0, all the data might have been deleted.
	nrecords = DmNumRecords(schedule);
	if(nrecords <= 0) return; // no schedule data

	lastrecordno = 0;
	diff = -1;
	jumpdate.year = year-1904;
	jumpdate.month = month;
	jumpdate.day = day;
	jumpdays = DateToDays(jumpdate);

	for(recordno=0;recordno<nrecords;recordno++){
		h = DmQueryRecord(schedule,recordno);
		if(h) nodata = false;
		if(h && (s0 = MemHandleLock(h))){
			date = *((DateType*)(s0+4));
			MemHandleUnlock(h);

			days = DateToDays(date);

			newdiff = (long)days - (long)jumpdays;
			if(newdiff < 0) newdiff = -newdiff;
			if(newdiff < diff || diff < 0){
				lastrecordno = recordno;
				diff = newdiff;
			}
		}
	}

	if(1){ // if(! found){
#ifdef CREATERECORD
		//
		// create a new record with no time specification
		//
		MemMove(newdata,"\377\377\377\377xx\004\262(new data)\000",19);
		packed = ((year-1900-4)<<9)+(month<<5)+day;
		newdata[4] = (packed>>8);
		newdata[5] = (packed&0xff);

		h = DmNewRecord(schedule,&recordno,19);
		if(h && (s0 = MemHandleLock(h))){
			err = DmWrite(s0,0,newdata,19);
			ErrFatalDisplayIf(err,"DmWrite");
			DmReleaseRecord(schedule,recordno,true);
			MemHandleUnlock(h);
		}
#else
		recordno = lastrecordno;
#endif
	}
	DmOpenDatabaseInfo(schedule,&scheduledbid,NULL,NULL,&scheduledbcardno,NULL);
	if(!scheduleisopen){
		DmCloseDatabase(schedule);
	}

	if(nodata) return;

	//
	// Launch the 'schedule' application. This seems to work even where
	// schedule is already running.
	//
	cmdPBP = (GoToParamsType*)MemPtrNew(sizeof(GoToParamsType));
	DmGetNextDatabaseByTypeCreator(true,&state,'appl',
		StringToLong(app), // 'date', etc.
		false,&scheduleappcardno,&scheduleappid);
	cmdPBP->searchStrLen = 0;
	cmdPBP->dbCardNo = scheduledbcardno;
	cmdPBP->dbID = scheduledbid;
	cmdPBP->recordNum = recordno;
	cmdPBP->matchPos = 0;
	cmdPBP->matchFieldNum = 0; 
	cmdPBP->matchCustom = 0;
	MemPtrSetOwner((VoidPtr)cmdPBP,0);
	SysUIAppSwitch(scheduleappcardno,scheduleappid,sysAppLaunchCmdGoTo,(Ptr)cmdPBP);
}


// Inline POBox̒萔Ȃ
#define DICTYPE 'EDIC'
#define LDICTYPE 'LDIC'
#define CREATORID 'PBIN'

int
NextDictRecord(int resid, int c, char *extra, int nextra);

Boolean
ConvertPOBox(unsigned char *pat, unsigned char *new)
{
	DmOpenRef dic;                // POBoxInline 
	DmOpenRef ldic;               // wKPDB
	
#define MAXEXTRA 0x100
	unsigned char extra[MAXEXTRA];
	int nextra;
	int i;

	register unsigned char *s,*p,*sw;
	DmOpenRef ds;
	Boolean found;
	int resid;
	VoidHand h;

//WinDrawChars(pat,StrLen(pat),40,10);

	if(pat == NULL || *pat == NULL) return false;

	// Open POBox dictionaries... ldic may by NULL
	ldic = DmOpenDatabaseByTypeCreator(LDICTYPE,CREATORID,dmModeReadOnly);
	dic = DmOpenDatabaseByTypeCreator(DICTYPE,CREATORID,dmModeReadOnly);
	if(dic == NULL) return false;

	//
	//	g̐Ɛ擪𒲍
	//
	nextra = DmNumRecords(dic) - 0xa00;
	if(nextra > MAXEXTRA) nextra = MAXEXTRA;
	for(i=0;i< nextra;i++){
		unsigned char *s0;
		VoidHand h;
		h = DmQueryRecord(dic,0xa00+i);
		ErrFatalDisplayIf(h==NULL,"Can't open extra dictionary area");
		s0 = MemHandleLock(h);
			extra[i] = *s0;
		MemHandleUnlock(h);
	}

	//
	//	Search POBox dictionaries and make the transition table.
	//
	//
	// {Pꎫ/gPꎫ̊S}b`
	//
	resid = (int)(*pat);

	ds = (resid < 0x100 && ldic ? ldic : dic);

	found = false;
	while(!found && resid){
		h = DmQueryRecord(ds,resid);
		if(h && (s = MemHandleLock(h))){
			while(*s){ // DB̍ŌNULL
				for(p = pat;*p && (*p == *s || *s == ' '); p++,s++);
				if(*p == '\0'){
					for(;*s && *s != '\002';s++);
					s++;
					found = true;
					break;
				}
				for(;*s;s++);
				s++;
			}
			MemHandleUnlock(h);
			if(found){
				p = new;
				s = sw;
				while(*s){
					if(*s == '\002'){
						p = new;
						s++;
						continue;
					}
					*p++ = *s++;
				}
				*p = '\0';
				break;
			}
		}
		//
		// ̒Pꎫ
		//
		resid = NextDictRecord(resid,(int)(*pat),extra,nextra);
		ds = dic;
	}
	if(dic) DmCloseDatabase(dic);
	if(ldic) DmCloseDatabase(ldic);
/*
{
char buf[100];
StrPrintF(buf,"found=%d",found);
WinDrawChars(buf,StrLen(buf),40,20);
}
*/
	return found;
}

int
NextDictRecord(int resid, int c, char *extra, int nextra)
{
	if(resid == c){
		resid = 0xa00;
	}
	else {
		resid++;
	}
	for(;resid < 0xa00 + nextra;resid++){
		if(extra[resid - 0xa00] == c) return resid;
	}
	return 0;
}

// Returns true if the result should be used for invoking Memo app.
Boolean
DoDragAndDrop(unsigned char *src, unsigned char *dst)
{
	int len,srclen;
	//
	//  Drag&DropW[Ăяo
	//
	len = StrLen(dst);
	srclen = StrLen(src);
	if(len >= 6 && dst[len-1] == '}'){
		//  W[CreatorID𒆊ʂłĎw肷B
		//  e.g. "ds#{PBTS}"  ([U`̏ꍇ)
		//  s蒷̏ꍇ́Ał}b`eLXgƂċ󔒕g
		//  "1<sp><sp><sp>...<sp>#{CTAB}"
		//  ̂悤ɒ`BW[@\T|[gĂꍇ
		//  "1<sp><sp><sp>...<sp>#{CTAB2}"
		//  ̂悤ɂB
		//  ܂A"@word" ȂǂƃvtBNXƂɃW[
		//  Ăяo悤ɂꍇ
		//  "@<sp><sp><sp>...<sp>#@{CTAB2}"
		//  ̂悤ɋʃvtBNXw肷ƁA
		//  vtBNX񂪃W[ɂ킽B
		//
		unsigned char *s,*p;
		int start;
		s = src;
		p = dst;
		for(start=0;s[start]==p[start];start++); // vtBNXXLbv
		if(p[start]=='{' && len-start >= 6){
			Err err;
			unsigned short cardNo;
			unsigned long result;
			LocalID dbID;
			DmSearchStateType searchState;
			tDropLaunchCmdParamRec *cmdPBP;
			unsigned long creatorID;

			creatorID = StringToLong(dst+start+1);

			// AvP[V̌
			err = DmGetNextDatabaseByTypeCreator (true, &searchState, 
				/*sysFileTApplication*/'appl', creatorID, false, &cardNo, &dbID);
			if(err) return true;

			cmdPBP = (tDropLaunchCmdParamRec*)MemPtrNew(sizeof(tDropLaunchCmdParamRec));
			cmdPBP->selector = ((dst[start+5] >= '0' && dst[start+5] <= '9') ? dst[start+5]-'0' : 0); // W[̉Ԗڂ̋@\
			cmdPBP->srcTextLength = srclen - start;
			cmdPBP->srcText = src + start;
			cmdPBP->resultTextLength = 0;
			cmdPBP->resultText = NULL;
			cmdPBP->resultBehavior = 0;
			
			MemPtrSetOwner((VoidPtr)cmdPBP,0);
//			err = SysAppLaunch (cardNo, dbID, 0,
//				dDropLaunchCmd, (Ptr)&param, &result);
			err = SysAppLaunch (cardNo, dbID, 0,
				dDropLaunchCmd, (Ptr)cmdPBP, &result);
			ErrFatalDisplayIf(err, "Error sending lookup action to app");

			if(! cmdPBP->resultText) return false;
			StrNCopy(dst,cmdPBP->resultText,cmdPBP->resultTextLength);
			dst[cmdPBP->resultTextLength] = '\0';
			MemPtrFree(cmdPBP->resultText); // 󂯎FreeƂD&D̎dl
		}
	}
	return true;
}
