//
//	$Date: 2001/03/19 23:20:38 $
//	$Revision: 1.2 $
//
#pragma pack(2)

#include <Pilot.h>
#include "palmwiki.h"
#include "id.h"

static VoidPtr GetObjectPtr(Word objectID)
{
	FormPtr frm;
	
	frm = FrmGetActiveForm();
	return (FrmGetObjectPtr(frm, FrmGetObjectIndex (frm, objectID)));
}


Boolean PrefsHandleEvent(EventPtr event)
{
	Boolean handled = false;
	FieldPtr field;
	ControlPtr ctl;
	char *s;

	UShort prefsize;
	WikiPref pref;

	switch(event->eType){
	case ctlSelectEvent:
		switch (event->data.ctlSelect.controlID){
		case ID_BUTTON_OK:
			field = (FieldPtr)GetObjectPtr(ID_FIELD_LPAR);
			s = FldGetTextPtr(field);
			StrCopy(pref.lpar,s);
			field = (FieldPtr)GetObjectPtr(ID_FIELD_RPAR);
			s = FldGetTextPtr(field);
			StrCopy(pref.rpar,s);
			field = (FieldPtr)GetObjectPtr(ID_FIELD_MEMO);
			s = FldGetTextPtr(field);
			StrCopy(pref.memo,s);
			field = (FieldPtr)GetObjectPtr(ID_FIELD_DATE);
			s = FldGetTextPtr(field);
			StrCopy(pref.date,s);
			ctl = GetObjectPtr(ID_CHECKBOX_SINGLETAP);
			pref.singletap = (int)CtlGetValue(ctl);

			PrefSetAppPreferences(CREATOR,0,1,&pref,sizeof(WikiPref),true);
			
			FrmGotoForm(9000); // Go back to HackMaster form
			handled = true;
			break;
		default:
			break;
		}
		break;
  	case frmOpenEvent:
        	FrmDrawForm(FrmGetActiveForm());

		GsiSetLocation(143,15);
		GsiEnable(true);

		prefsize = sizeof(WikiPref);
		if(PrefGetAppPreferences(CREATOR,0,&pref,&prefsize,true) == noPreferenceFound){
			// ErrFatalDisplayIf(true,"Can't open Pref DB");
			StrCopy(pref.lpar,DEFAULT_LEFT_TAG);
			StrCopy(pref.rpar,DEFAULT_RIGHT_TAG);
			StrCopy(pref.memo,DEFAULT_MEMO_APP);
			StrCopy(pref.date,DEFAULT_DATE_APP);
			pref.singletap = true;
			PrefSetAppPreferences(CREATOR,0,1,&pref,sizeof(WikiPref),true);
		}
		field = (FieldPtr)GetObjectPtr(ID_FIELD_LPAR);
		FldInsert(field,pref.lpar,StrLen(pref.lpar));
		field = (FieldPtr)GetObjectPtr(ID_FIELD_RPAR);
		FldInsert(field,pref.rpar,StrLen(pref.rpar));
		field = (FieldPtr)GetObjectPtr(ID_FIELD_MEMO);
		FldInsert(field,pref.memo,StrLen(pref.memo));
		field = (FieldPtr)GetObjectPtr(ID_FIELD_DATE);
		FldInsert(field,pref.date,StrLen(pref.date));
		ctl = GetObjectPtr(ID_CHECKBOX_SINGLETAP);
		CtlSetValue(ctl, (short)pref.singletap);
		handled = true;
		break;
	default:
		handled = false;
		break;
	}
	return handled;
}

